@echo off
REM WinNT/2000/XP-only
REM 
REM Registers the External IP of this computer (as perceived from the Internet)
REM (i.e. the IP of the NAT box/Firewall/Proxy if behind one)
REM with the appropriate authoritative DNS server (with non-secure DDNS update)
REM under the Fully Qualified DNS name provided in the first parameter
REM 
REM Requires IE 5+
REM 
REM Requires whatismyip.vbs, BIND's nsupdate.exe (which requires libbind.dll)
REM and on Win2000/XP, dnsservers.bat.  All of these are to be either in the PATH,
REM the current directory, the same directory as this batch file
REM or in the directory specified in the PROG_SOURCE variable.

rem Note: this batch file is self-documenting. Uppercase rem statements will be displayed
rem when executed with /?

if NOT !%OS%==!Windows_NT echo Sorry, this is for WinNT/2000/XP-only!
if NOT !%OS%==!Windows_NT goto end

if /%1==/ goto error

if /I %1==/? goto help
if /I %1==--? goto help
if /I %1==-? goto help
if /I %1==/help goto help
if /I %1==--help goto help
if /I %1==-help goto help

SETLOCAL

if "%PROG_SOURCE%"=="" set PROG_SOURCE=%~dp0
if not exist %PROG_SOURCE%nsupdate.exe set PROG_SOURCE=


set FQDN=%1
rem Remove quotes
set FQDN=%FQDN:"=%
rem Remove trailing .
set FQDN=%FQDN%#!#
set FQDN=%FQDN:.#!#=%
set FQDN=%FQDN:#!#=%

rem Make sure it's fully-qualified:
echo %FQDN%|findstr .*\..*\..*>nul
IF ERRORLEVEL 1 goto error

set TTL=86400

rem Get our External IP from the WhatIsMyIp.org service:
FOR /F %%I IN ('cscript /nologo %PROG_SOURCE%whatismyip.vbs') DO set EXTERNALIP=%%I

ver |find "4.0">nul
IF NOT ERRORLEVEL 1 goto skipDNS

rem Under 2000/XP, BIND utilities need the resolv.conf file
rem To obtain the DNS servers because the registry locations have
rem changed from NT4 - they are now per-interface, not global

rem Only create/update the resolv.conf file if it doesn't exist
rem or it was generated by dnsservers.bat in the first place

if not exist %windir%\system32\drivers\etc\resolv.conf goto new
type %windir%\system32\drivers\etc\resolv.conf |find "dnsservers.bat">nul
IF ERRORLEVEL 1 goto skipDNS
:new
echo #generated by dnsservers.bat on %DATE% %TIME%>%windir%\system32\drivers\etc\resolv.conf
call %PROG_SOURCE%dnsservers.bat nameserver>>%windir%\system32\drivers\etc\resolv.conf
:skipDNS

rem Create the nsupdate script:
if exist %temp%\nsupdate.txt del %temp%\nsupdate.txt
echo update delete %FQDN% A>%temp%\nsupdate.txt
echo update add %FQDN% %TTL% A %EXTERNALIP%>>%temp%\nsupdate.txt
echo.>>%temp%\nsupdate.txt
echo.>>%temp%\nsupdate.txt

echo.
echo Registering %FQDN% under %EXTERNALIP% ...
echo.
%PROG_SOURCE%nsupdate %temp%\nsupdate.txt

if exist %temp%\nsupdate.txt del %temp%\nsupdate.txt

ENDLOCAL

goto end

:error
echo.
echo Error: Please specify the Fully Qualified Host Name to register!
echo.

:help
rem Self-document:
FOR /F "tokens=1*" %%I IN ('type "%~f0"^|findstr /B REM') DO (if NOT "%%J"=="" echo %%J) & (if "%%J"=="" echo.)
goto :EOF

:end
