@echo off
REM Win2k/XP-only

REM Lists the DNS servers for all interfaces on this computer

REM Optionally specify a string in %1 to prepend the ip address with (and a space).
REM Quote the string if it has spaces.

REM i.e. 'dnsservers.bat nameserver>%windir%\system32\drivers\etc\resolv.conf'
REM will generate a valid resolv.conf file that can be used by BIND utilities

REM Note that under NT4, BIND utilities are able to retrieve the info from the
REM registry and hence do not need the resolv.conf file)

SETLOCAL

IF (%1)==() goto default

set PREPEND=%1
set PREPEND=%PREPEND:"=%
set PREPEND=%PREPEND% 
rem Note that there is a trailing space in the line above!
goto run

:default
set PREPEND=

:run
FOR /F "tokens=1,5 delims=: " %%I IN ('netsh interface ip show dns^|findstr [0-9]\.[0-9]') DO IF "%%I"=="Statically" (echo %PREPEND%%%J) ELSE echo %PREPEND%%%I

ENDLOCAL